using System;
using System.Collections.Generic;

class Program
{
    static void Main()
    {
        int n = int.Parse(Console.ReadLine());

        long[] x = new long[n];
        long[] y = new long[n];

        for (int i = 0; i < n; i++)
        {
            var t = Console.ReadLine().Split();
            x[i] = long.Parse(t[0]);
            y[i] = long.Parse(t[1]);
        }

        bool[] used = new bool[n];
        long sx = 0, sy = 0;
        double bestDist = 0;

        for (int i = 0; i < n; i++)
        {
            long nsx = sx + x[i];
            long nsy = sy + y[i];
            double newDist = (double)nsx * nsx + (double)nsy * nsy;

            if (newDist > bestDist)
            {
                used[i] = true;
                sx = nsx;
                sy = nsy;
                bestDist = newDist;
            }
        }

        for (int i = 0; i < n; i++)
        {
            if (!used[i])
            {
                long nsx = sx + x[i];
                long nsy = sy + y[i];
                double newDist = (double)nsx * nsx + (double)nsy * nsy;

                if (newDist > bestDist)
                {
                    used[i] = true;
                    sx = nsx;
                    sy = nsy;
                    bestDist = newDist;
                }
            }
        }

        List<int> chosen = new List<int>();
        for (int i = 0; i < n; i++)
        {
            if (used[i])
            {
                chosen.Add(i + 1);
            }
        }

        Console.WriteLine(chosen.Count);
        Console.WriteLine(string.Join(" ", chosen));
    }
}